/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.collision;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.EndPortalEntity;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.CountDownInt;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements IEEntity,
ImmPtlEntityExtension {
    @Unique
    @Nullable
    private PortalCollisionHandler ip_portalCollisionHandler;
    @Shadow
    private class_1937 field_6002;
    @Shadow
    public int field_6012;
    @Shadow
    private class_243 field_22467;
    @Shadow
    private class_2338 field_22468;
    @Shadow
    private class_1923 field_35101;
    @Shadow
    @Final
    private static Logger field_5955;
    @Shadow
    @Nullable
    private class_2680 field_47742;
    @Unique
    private static final CountDownInt IMM_PTL_LOG_COUNTER;

    @Shadow
    protected abstract class_243 method_17835(class_243 var1);

    @Shadow
    public abstract class_2561 method_5477();

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract double method_23321();

    @Shadow
    protected abstract void method_31482();

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private class_243 redirectHandleCollisions(class_1297 entity, class_243 attemptedMove) {
        if (!IPGlobal.enableServerCollision && !entity.method_37908().method_8608()) {
            if (entity instanceof class_1657) {
                return attemptedMove;
            }
            return class_243.field_1353;
        }
        if (attemptedMove.method_1027() > 3600.0) {
            if (IMM_PTL_LOG_COUNTER.tryDecrement()) {
                field_5955.error("[ImmPtl] Skipping collision calculation because entity moves too fast {} {} {}", new Object[]{entity, attemptedMove, entity.method_37908().method_8510(), new Throwable()});
            }
            return class_243.field_1353;
        }
        if (!IPGlobal.crossPortalCollision || this.ip_portalCollisionHandler == null || !this.ip_portalCollisionHandler.hasCollisionEntry()) {
            class_243 normalCollisionResult = this.method_17835(attemptedMove);
            return normalCollisionResult;
        }
        class_243 result = this.ip_portalCollisionHandler.handleCollision((class_1297)this, attemptedMove);
        if (result.method_1027() > 400.0) {
            if (IMM_PTL_LOG_COUNTER.tryDecrement()) {
                field_5955.error("[ImmPtl] cross portal collision result too large {} {} {}", new Object[]{this, attemptedMove, result});
            }
            return class_243.field_1353;
        }
        return result;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_getCollidingPortal() instanceof EndPortalEntity) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;checkInsideBlocks()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;"))
    private class_238 redirectBoundingBoxInCheckingBlockCollision(class_1297 entity) {
        return this.ip_getActiveCollisionBox(entity.method_5829());
    }

    @Inject(method={"checkInsideBlocks"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onCheckInsideBlocks(CallbackInfo ci, class_238 box) {
        if (box == null) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isInWall()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInsideWall(CallbackInfoReturnable<Boolean> cir) {
        if (this.ip_isRecentlyCollidingWithPortal()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;setPosRaw(DDD)V"}, at={@At(value="HEAD")})
    private void onSetPos(double nx, double ny, double nz, CallbackInfo ci) {
        class_1297 this_ = (class_1297)this;
        if (this_ instanceof class_1657 && IPGlobal.teleportationDebugEnabled && (Math.abs(this.method_23317() - nx) > 10.0 || Math.abs(this.method_23318() - ny) > 10.0 || Math.abs(this.method_23321() - nz) > 10.0)) {
            Helper.log(String.format("%s %s teleported from %s %s %s to %s %s %s", this.method_5477().method_10851(), this.field_6002.method_27983(), (int)this.method_23317(), (int)this.method_23318(), (int)this.method_23321(), (int)nx, (int)ny, (int)nz));
            new Throwable().printStackTrace();
        }
    }

    @Inject(method={"getInBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetInBlockState(CallbackInfoReturnable<class_2680> cir) {
        Portal collidingPortal = this.ip_getCollidingPortal();
        class_1297 this_ = (class_1297)this;
        if (collidingPortal != null && collidingPortal.getNormal().field_1351 > 0.0) {
            class_2680 result;
            class_2338 remoteLandingPos = class_2338.method_49638((class_2374)collidingPortal.transformPoint(this_.method_19538()));
            class_1937 destinationWorld = collidingPortal.getDestinationWorld();
            if (destinationWorld.method_22340(remoteLandingPos) && !(result = destinationWorld.method_8320(remoteLandingPos)).method_26215()) {
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }

    @Override
    public Portal ip_getCollidingPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return null;
        }
        if (this.ip_portalCollisionHandler.portalCollisions.isEmpty()) {
            return null;
        }
        return this.ip_portalCollisionHandler.portalCollisions.get((int)0).portal;
    }

    @Override
    public void ip_tickCollidingPortal() {
        class_1297 this_ = (class_1297)this;
        if (this.ip_portalCollisionHandler != null) {
            this.ip_portalCollisionHandler.update(this_);
        }
        if (this.field_6002.field_9236) {
            IPMcHelper.onClientEntityTick(this_);
        }
    }

    @Override
    public void ip_notifyCollidingWithPortal(class_1297 portal) {
        class_1297 this_ = (class_1297)this;
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        this.ip_portalCollisionHandler.notifyCollidingWithPortal(this_, (Portal)portal);
    }

    @Override
    public boolean ip_isCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.hasCollisionEntry();
    }

    @Override
    public boolean ip_isRecentlyCollidingWithPortal() {
        if (this.ip_portalCollisionHandler == null) {
            return false;
        }
        return this.ip_portalCollisionHandler.isRecentlyCollidingWithPortal((class_1297)this);
    }

    @Override
    public void ip_unsetRemoved() {
        this.method_31482();
    }

    @Override
    @IPVanillaCopy
    public void ip_setPositionWithoutTriggeringCallback(class_243 newPos) {
        double x = newPos.field_1352;
        double y = newPos.field_1351;
        double z = newPos.field_1350;
        if (this.field_22467.field_1352 != x || this.field_22467.field_1351 != y || this.field_22467.field_1350 != z) {
            this.field_22467 = new class_243(x, y, z);
            int bx = class_3532.method_15357((double)x);
            int by = class_3532.method_15357((double)y);
            int bz = class_3532.method_15357((double)z);
            if (bx != this.field_22468.method_10263() || by != this.field_22468.method_10264() || bz != this.field_22468.method_10260()) {
                this.field_22468 = new class_2338(bx, by, bz);
                this.field_47742 = null;
                if (class_4076.method_18675((int)bx) != this.field_35101.field_9181 || class_4076.method_18675((int)bz) != this.field_35101.field_9180) {
                    this.field_35101 = new class_1923(this.field_22468);
                }
            }
        }
    }

    @Override
    public void ip_clearCollidingPortal() {
        this.ip_portalCollisionHandler = null;
    }

    @Override
    @Nullable
    public class_238 ip_getActiveCollisionBox(class_238 originalBox) {
        class_1297 this_ = (class_1297)this;
        if (this.ip_portalCollisionHandler == null) {
            return originalBox;
        }
        return this.ip_portalCollisionHandler.getActiveCollisionBox(this_, originalBox);
    }

    @Override
    @Nullable
    public PortalCollisionHandler ip_getPortalCollisionHandler() {
        return this.ip_portalCollisionHandler;
    }

    @Override
    public PortalCollisionHandler ip_getOrCreatePortalCollisionHandler() {
        if (this.ip_portalCollisionHandler == null) {
            this.ip_portalCollisionHandler = new PortalCollisionHandler();
        }
        return this.ip_portalCollisionHandler;
    }

    @Override
    public void ip_setPortalCollisionHandler(@Nullable PortalCollisionHandler handler) {
        this.ip_portalCollisionHandler = handler;
    }

    @Override
    public void ip_setWorld(class_1937 world) {
        this.field_6002 = world;
    }

    private long ip_getStableTiming() {
        return this.field_6012;
    }

    static {
        IMM_PTL_LOG_COUNTER = new CountDownInt(20);
    }
}

